from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class OppositeGrudger(Player):
    """
    A player starts by defecting however will cooperate if at any point the
    opponent has cooperated.

    Names:

    - Opposite Grudger: Original name by Geraint Palmer
    """

    name = "Opposite Grudger"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    @staticmethod
    def strategy(opponent: Player) -> Action:
        """Begins by playing D, then plays C for the remaining rounds if the
        opponent ever plays C."""
        if opponent.cooperations:
            return C
        return D